import carla
# from srunner.scenarioconfigs.scenario_configuration import ScenarioConfiguration
# from srunner.scenarioconfigs.route_scenario_configuration import RouteScenarioConfiguration

class ScenarioConfiguration(object):

    """
    This class provides a basic scenario configuration incl.:
    - configurations for all actors
    - town, where the scenario should be executed
    - name of the scenario (e.g. ControlLoss_1)
    - type is the class of scenario (e.g. ControlLoss)
    """

    def __init__(self):
        self.trigger_points = []
        self.ego_vehicles = []
        self.other_actors = []
        self.other_parameters = {}
        self.town = None
        self.name = None
        self.type = None
        self.route = None
        self.agent = None
        self.weather = carla.WeatherParameters(sun_altitude_angle=70, cloudiness=50)
        self.friction = None
        self.subtype = None
        self.route_var_name = None


def parse_scenario_config(config) -> ScenarioConfiguration:
    scenario_config = ScenarioConfiguration()
    scenario_config.town = config.map
    scenario_config.name = config.scenarioname
    scenario_config.type = config.scenarioname
    scenario_config.accident_prone = config.accident_prone
    scenario_config.ego_vehicles = config.vehicles
    scenario_config.route = config.vehicles[0].route
    scenario_config.route_var_name = config.route_var_name
    scenario_config.other_actors = config.other_actors
    scenario_config.trigger_points.append(convert_dict_to_transform(config.trigger_point))
    scenario_config.weather = parse_weather(config.weather)
    return scenario_config

def parse_weather(config):
    weather = carla.WeatherParameters()
    weather.cloudiness = config.get('cloudiness', 0.0)
    weather.precipitation = config.get('precipitation', 0.0)
    weather.precipitation_deposits = config.get('precipitation_deposits', 0.0)
    weather.wind_intensity = config.get('wind_intensity', 0.0)
    weather.sun_azimuth_angle = config.get('sun_azimuth_angle', 0.0)
    weather.sun_altitude_angle = config.get('sun_altitude_angle', 0.0)
    return weather

def convert_dict_to_transform(config):
    return carla.Transform(
                 carla.Location(x=config.x, y=config.y, z=config.z),
                 carla.Rotation(pitch=config.get('pitch', 0),
                                yaw=config.get('yaw', 0),
                                roll=config.get('roll', 0))
            )